<?php

namespace Tests\Feature;

use App\Models\Organization;
use App\Models\ServiceArea;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class IncidentRoutingTest extends TestCase
{
    use RefreshDatabase;

    public function test_incident_routes_to_organization_by_service_area(): void
    {
        $org = Organization::factory()->create();
        
        ServiceArea::factory()->create([
            'organization_id' => $org->id,
            'service_type' => 'electricity',
            'min_latitude' => 5.25,
            'max_latitude' => 5.35,
            'min_longitude' => -4.05,
            'max_longitude' => -3.95,
        ]);

        $user = User::factory()->create();
        $user->roles()->attach(\App\Models\Role::factory()->create(['name' => 'CITIZEN']));

        $response = $this->actingAs($user, 'sanctum')
            ->postJson('/api/v1/incidents', [
                'service_type' => 'electricity',
                'title' => 'Test Incident',
                'description' => 'Test description',
                'latitude' => 5.30,
                'longitude' => -4.00,
            ]);

        $response->assertStatus(201);
        $response->assertJsonPath('data.organization_id', $org->id);
    }

    public function test_incident_fails_if_no_service_area_match(): void
    {
        $user = User::factory()->create();
        $user->roles()->attach(\App\Models\Role::factory()->create(['name' => 'CITIZEN']));

        $response = $this->actingAs($user, 'sanctum')
            ->postJson('/api/v1/incidents', [
                'service_type' => 'electricity',
                'title' => 'Test Incident',
                'description' => 'Test description',
                'latitude' => 10.0, // Outside any service area
                'longitude' => 10.0,
            ]);

        $response->assertStatus(422);
    }
}

