#!/bin/bash

echo "🔧 MySQL Database Setup for NE-SOS"
echo "===================================="
echo ""

# Check if MySQL is running
if ! mysql -u root -e "SELECT 1" > /dev/null 2>&1; then
    echo "⚠️  MySQL root access requires a password."
    echo ""
    read -sp "Enter MySQL root password (press Enter if no password): " MYSQL_PASSWORD
    echo ""
    
    if [ -z "$MYSQL_PASSWORD" ]; then
        MYSQL_CMD="mysql -u root"
    else
        MYSQL_CMD="mysql -u root -p${MYSQL_PASSWORD}"
    fi
else
    MYSQL_CMD="mysql -u root"
fi

# Create database
echo "📦 Creating database 'ne_sos'..."
$MYSQL_CMD -e "CREATE DATABASE IF NOT EXISTS ne_sos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;" 2>&1

if [ $? -eq 0 ]; then
    echo "✅ Database created successfully!"
    
    # Update .env file
    if [ -n "$MYSQL_PASSWORD" ]; then
        sed -i '' "s/^DB_PASSWORD=$/DB_PASSWORD=${MYSQL_PASSWORD}/" .env 2>/dev/null || \
        sed -i "s/^DB_PASSWORD=$/DB_PASSWORD=${MYSQL_PASSWORD}/" .env
    fi
    
    echo ""
    echo "🚀 Running migrations and seeders..."
    php artisan migrate:fresh --seed --force
    
    if [ $? -eq 0 ]; then
        echo ""
        echo "✅ Setup complete! You can now start the server with: php artisan serve"
    else
        echo ""
        echo "❌ Migration failed. Please check your database credentials in .env"
    fi
else
    echo "❌ Failed to create database. Please check your MySQL credentials."
    echo ""
    echo "You can manually create the database:"
    echo "  mysql -u root -p -e \"CREATE DATABASE ne_sos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;\""
    echo ""
    echo "Then update .env with your MySQL password and run:"
    echo "  php artisan migrate:fresh --seed"
fi
