#!/bin/bash
echo "🔧 NE-SOS MySQL Database Setup"
echo "================================"
echo ""

# Check MySQL socket
MYSQL_SOCKET=$(find /opt/homebrew /usr/local -name "mysql.sock" 2>/dev/null | head -1)
if [ -z "$MYSQL_SOCKET" ]; then
    MYSQL_SOCKET="/tmp/mysql.sock"
fi

echo "📝 Please run these commands manually:"
echo ""
echo "1. Create the database:"
echo "   mysql -u root -p -e \"CREATE DATABASE ne_sos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;\""
echo ""
echo "2. Update .env file with your MySQL password:"
echo "   Edit backend/.env and set DB_PASSWORD=your_password"
echo ""
echo "3. Run migrations and seeders:"
echo "   cd backend"
echo "   php artisan migrate:fresh --seed"
echo ""
echo "📖 See MYSQL_SETUP.md for detailed instructions"
