<?php

use App\Http\Controllers\Api\V1\CommentController;
use App\Http\Controllers\Api\V1\DeviceTokenController;
use App\Http\Controllers\Api\V1\IncidentController;
use App\Http\Controllers\Api\V1\IncidentTypeController;
use App\Http\Controllers\Api\V1\NotificationController;
use App\Http\Controllers\Api\V1\OrganizationController;
use App\Http\Controllers\Api\V1\RoleController;
use App\Http\Controllers\Api\V1\TeamController;
use App\Http\Controllers\Api\V1\UserController;
use App\Http\Controllers\Auth\AuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// Public routes
Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);
});

// Authenticated routes
Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('auth')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::get('/me', [AuthController::class, 'me']);
    });

    Route::prefix('v1')->group(function () {
        // Incidents
        Route::apiResource('incidents', IncidentController::class);
        Route::post('incidents/{incident}/assign', [IncidentController::class, 'assign']);
        Route::post('incidents/{incident}/unassign', [IncidentController::class, 'unassign']);
        Route::post('incidents/{incident}/status', [IncidentController::class, 'changeStatus']);
        Route::get('incidents/{incident}/timeline', [IncidentController::class, 'timeline']);
        Route::post('incidents/{incident}/timeline', [IncidentController::class, 'addTimelineEvent']);
        Route::post('incidents/{incident}/media', [IncidentController::class, 'addMedia']);

        // Comments (for incidents and assignments)
        Route::get('comments', [CommentController::class, 'index']);
        Route::post('comments', [CommentController::class, 'store']);
        Route::delete('comments/{comment}', [CommentController::class, 'destroy']);

        // Organizations (super admin + org admin)
        Route::apiResource('organizations', OrganizationController::class);

        // Roles
        Route::get('roles', [RoleController::class, 'index']);

        // Users
        Route::apiResource('users', UserController::class);

        // Teams
        Route::apiResource('teams', TeamController::class);
        Route::put('teams/{team}/members', [TeamController::class, 'updateMembers']);

        // Incident Types & Service Types
        Route::get('incident-types/service-types', [IncidentTypeController::class, 'getServiceTypes']);
        Route::get('incident-types', [IncidentTypeController::class, 'index']);

        // Notifications
        Route::get('notifications', [NotificationController::class, 'index']);
        Route::post('notifications/{id}/read', [NotificationController::class, 'markAsRead']);
        Route::post('notifications/read-all', [NotificationController::class, 'markAllAsRead']);

        // Device Tokens (for FCM push notifications)
        Route::post('device-tokens', [DeviceTokenController::class, 'store']);
        Route::delete('device-tokens/{token}', [DeviceTokenController::class, 'destroy']);
    });
});

