<?php

namespace Database\Seeders;

use App\Models\Organization;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $cie = Organization::where('slug', 'cie-electricity-abidjan')->first();
        $sodeci = Organization::where('slug', 'sodeci-water-abidjan')->first();

        $roles = [
            'ORG_ADMIN' => Role::where('name', 'ORG_ADMIN')->first(),
            'DISPATCHER' => Role::where('name', 'DISPATCHER')->first(),
            'LEAD_AGENT' => Role::where('name', 'LEAD_AGENT')->first(),
            'FIELD_AGENT' => Role::where('name', 'FIELD_AGENT')->first(),
            'CITIZEN' => Role::where('name', 'CITIZEN')->first(),
        ];

        // CIE Users
        if ($cie) {
            $cieAdmin = User::firstOrCreate(
                ['email' => 'admin@cie.ci'],
                [
                    'organization_id' => $cie->id,
                    'name' => 'CIE Admin',
                    'password' => Hash::make('password'),
                    'is_active' => true,
                ]
            );
            $cieAdmin->roles()->syncWithoutDetaching([$roles['ORG_ADMIN']->id]);

            $cieDispatcher = User::firstOrCreate(
                ['email' => 'dispatcher@cie.ci'],
                [
                    'organization_id' => $cie->id,
                    'name' => 'CIE Dispatcher',
                    'password' => Hash::make('password'),
                    'is_active' => true,
                ]
            );
            $cieDispatcher->roles()->syncWithoutDetaching([$roles['DISPATCHER']->id]);

            $cieLeadAgent = User::firstOrCreate(
                ['email' => 'lead@cie.ci'],
                [
                    'organization_id' => $cie->id,
                    'name' => 'CIE Lead Agent',
                    'password' => Hash::make('password'),
                    'is_active' => true,
                ]
            );
            $cieLeadAgent->roles()->syncWithoutDetaching([$roles['LEAD_AGENT']->id]);

            // Create 10 field agents
            for ($i = 1; $i <= 10; $i++) {
                $agent = User::firstOrCreate(
                    ['email' => "agent{$i}@cie.ci"],
                    [
                        'organization_id' => $cie->id,
                        'name' => "CIE Field Agent {$i}",
                        'password' => Hash::make('password'),
                        'is_active' => true,
                    ]
                );
                $agent->roles()->syncWithoutDetaching([$roles['FIELD_AGENT']->id]);
            }

            // Create 20 citizens
            for ($i = 1; $i <= 20; $i++) {
                $citizen = User::firstOrCreate(
                    ['email' => "citizen{$i}@cie.ci"],
                    [
                        'organization_id' => $cie->id,
                        'name' => "Citizen {$i}",
                        'password' => Hash::make('password'),
                        'is_active' => true,
                    ]
                );
                $citizen->roles()->syncWithoutDetaching([$roles['CITIZEN']->id]);
            }
        }

        // SODECI Users
        if ($sodeci) {
            $sodeciAdmin = User::firstOrCreate(
                ['email' => 'admin@sodeci.ci'],
                [
                    'organization_id' => $sodeci->id,
                    'name' => 'SODECI Admin',
                    'password' => Hash::make('password'),
                    'is_active' => true,
                ]
            );
            $sodeciAdmin->roles()->syncWithoutDetaching([$roles['ORG_ADMIN']->id]);

            $sodeciDispatcher = User::firstOrCreate(
                ['email' => 'dispatcher@sodeci.ci'],
                [
                    'organization_id' => $sodeci->id,
                    'name' => 'SODECI Dispatcher',
                    'password' => Hash::make('password'),
                    'is_active' => true,
                ]
            );
            $sodeciDispatcher->roles()->syncWithoutDetaching([$roles['DISPATCHER']->id]);

            // Create 2 lead agents
            for ($i = 1; $i <= 2; $i++) {
                $lead = User::firstOrCreate(
                    ['email' => "lead{$i}@sodeci.ci"],
                    [
                        'organization_id' => $sodeci->id,
                        'name' => "SODECI Lead Agent {$i}",
                        'password' => Hash::make('password'),
                        'is_active' => true,
                    ]
                );
                $lead->roles()->syncWithoutDetaching([$roles['LEAD_AGENT']->id]);
            }

            // Create 12 field agents
            for ($i = 1; $i <= 12; $i++) {
                $agent = User::firstOrCreate(
                    ['email' => "agent{$i}@sodeci.ci"],
                    [
                        'organization_id' => $sodeci->id,
                        'name' => "SODECI Field Agent {$i}",
                        'password' => Hash::make('password'),
                        'is_active' => true,
                    ]
                );
                $agent->roles()->syncWithoutDetaching([$roles['FIELD_AGENT']->id]);
            }

            // Create 20 citizens
            for ($i = 1; $i <= 20; $i++) {
                $citizen = User::firstOrCreate(
                    ['email' => "citizen{$i}@sodeci.ci"],
                    [
                        'organization_id' => $sodeci->id,
                        'name' => "Citizen {$i}",
                        'password' => Hash::make('password'),
                        'is_active' => true,
                    ]
                );
                $citizen->roles()->syncWithoutDetaching([$roles['CITIZEN']->id]);
            }
        }
    }
}

