<?php

namespace Database\Seeders;

use App\Models\Organization;
use App\Models\Team;
use App\Models\User;
use Illuminate\Database\Seeder;

class TeamSeeder extends Seeder
{
    public function run(): void
    {
        $cie = Organization::where('slug', 'cie-electricity-abidjan')->first();
        $sodeci = Organization::where('slug', 'sodeci-water-abidjan')->first();

        if ($cie) {
            $cieAgents = User::where('organization_id', $cie->id)
                ->whereHas('roles', fn($q) => $q->where('name', 'FIELD_AGENT'))
                ->pluck('id');
            $cieLeads = User::where('organization_id', $cie->id)
                ->whereHas('roles', fn($q) => $q->where('name', 'LEAD_AGENT'))
                ->pluck('id');

            // Create multiple teams
            $teams = [
                [
                    'name' => 'CIE Emergency Response Team',
                    'description' => 'Emergency response team for critical electricity incidents',
                    'service_type' => 'electricity',
                    'members' => $cieAgents->take(3),
                ],
                [
                    'name' => 'CIE Maintenance Team Alpha',
                    'description' => 'Routine maintenance and repairs team',
                    'service_type' => 'electricity',
                    'members' => $cieAgents->skip(3)->take(3),
                ],
                [
                    'name' => 'CIE Street Lighting Team',
                    'description' => 'Specialized team for street light maintenance',
                    'service_type' => 'electricity',
                    'members' => $cieAgents->skip(6)->take(2),
                ],
            ];

            foreach ($teams as $teamData) {
                if ($teamData['members']->isNotEmpty()) {
                    $team = Team::firstOrCreate(
                        [
                            'organization_id' => $cie->id,
                            'name' => $teamData['name'],
                        ],
                        [
                            'description' => $teamData['description'],
                            'service_type' => $teamData['service_type'],
                            'is_active' => true,
                        ]
                    );
                    $team->members()->sync($teamData['members']);
                }
            }
        }

        if ($sodeci) {
            $sodeciAgents = User::where('organization_id', $sodeci->id)
                ->whereHas('roles', fn($q) => $q->where('name', 'FIELD_AGENT'))
                ->pluck('id');
            $sodeciLeads = User::where('organization_id', $sodeci->id)
                ->whereHas('roles', fn($q) => $q->where('name', 'LEAD_AGENT'))
                ->pluck('id');

            // Create multiple teams
            $teams = [
                [
                    'name' => 'SODECI Water Maintenance Team',
                    'description' => 'Maintenance team for water incidents',
                    'service_type' => 'water',
                    'members' => $sodeciAgents->take(4),
                ],
                [
                    'name' => 'SODECI Leak Response Team',
                    'description' => 'Rapid response team for water leaks',
                    'service_type' => 'water',
                    'members' => $sodeciAgents->skip(4)->take(4),
                ],
                [
                    'name' => 'SODECI Quality Control Team',
                    'description' => 'Team handling water quality issues',
                    'service_type' => 'water',
                    'members' => $sodeciAgents->skip(8)->take(2),
                ],
            ];

            foreach ($teams as $teamData) {
                if ($teamData['members']->isNotEmpty()) {
                    $team = Team::firstOrCreate(
                        [
                            'organization_id' => $sodeci->id,
                            'name' => $teamData['name'],
                        ],
                        [
                            'description' => $teamData['description'],
                            'service_type' => $teamData['service_type'],
                            'is_active' => true,
                        ]
                    );
                    $team->members()->sync($teamData['members']);
                }
            }
        }
    }
}

