<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    public function run(): void
    {
        $superAdminRole = Role::where('name', 'SUPER_ADMIN')->first();

        $superAdmin = User::firstOrCreate(
            ['email' => 'admin@ne-sos.com'],
            [
                'name' => 'Super Administrator',
                'password' => Hash::make('password'),
                'is_active' => true,
            ]
        );

        if (!$superAdmin->hasRole('SUPER_ADMIN')) {
            $superAdmin->roles()->attach($superAdminRole);
        }
    }
}

