<?php

namespace Database\Seeders;

use App\Models\Organization;
use App\Models\ServiceArea;
use Illuminate\Database\Seeder;

class ServiceAreaSeeder extends Seeder
{
    public function run(): void
    {
        $cie = Organization::where('slug', 'cie-electricity-abidjan')->first();
        $sodeci = Organization::where('slug', 'sodeci-water-abidjan')->first();

        // Abidjan bounding box (approximate)
        // Latitude: 5.2 to 5.4, Longitude: -4.1 to -3.9

        // CIE Electricity service areas
        if ($cie) {
            ServiceArea::create([
                'organization_id' => $cie->id,
                'name' => 'Abidjan Central Electricity',
                'service_type' => 'electricity',
                'description' => 'Central Abidjan electricity service area',
                'min_latitude' => 5.25,
                'max_latitude' => 5.35,
                'min_longitude' => -4.05,
                'max_longitude' => -3.95,
                'is_active' => true,
            ]);

            ServiceArea::create([
                'organization_id' => $cie->id,
                'name' => 'Abidjan North Electricity',
                'service_type' => 'electricity',
                'description' => 'North Abidjan electricity service area covering Yopougon, Abobo, and surrounding areas',
                'min_latitude' => 5.30,
                'max_latitude' => 5.40,
                'min_longitude' => -4.05,
                'max_longitude' => -3.95,
                'is_active' => true,
            ]);

            ServiceArea::create([
                'organization_id' => $cie->id,
                'name' => 'Abidjan South Electricity',
                'service_type' => 'electricity',
                'description' => 'South Abidjan electricity service area covering Marcory, Port-Bouët, and surrounding areas',
                'min_latitude' => 5.20,
                'max_latitude' => 5.30,
                'min_longitude' => -4.05,
                'max_longitude' => -3.95,
                'is_active' => true,
            ]);
        }

        // SODECI Water service areas
        if ($sodeci) {
            ServiceArea::create([
                'organization_id' => $sodeci->id,
                'name' => 'Abidjan Central Water',
                'service_type' => 'water',
                'description' => 'Central Abidjan water service area covering Plateau, Cocody, and surrounding areas',
                'min_latitude' => 5.25,
                'max_latitude' => 5.35,
                'min_longitude' => -4.05,
                'max_longitude' => -3.95,
                'is_active' => true,
            ]);

            ServiceArea::create([
                'organization_id' => $sodeci->id,
                'name' => 'Abidjan South Water',
                'service_type' => 'water',
                'description' => 'South Abidjan water service area covering Yopougon, Marcory, and surrounding areas',
                'min_latitude' => 5.20,
                'max_latitude' => 5.30,
                'min_longitude' => -4.05,
                'max_longitude' => -3.95,
                'is_active' => true,
            ]);

            ServiceArea::create([
                'organization_id' => $sodeci->id,
                'name' => 'Abidjan East Water',
                'service_type' => 'water',
                'description' => 'East Abidjan water service area covering Adjamé, Anyama, and surrounding areas',
                'min_latitude' => 5.28,
                'max_latitude' => 5.38,
                'min_longitude' => -3.98,
                'max_longitude' => -3.88,
                'is_active' => true,
            ]);
        }

        $this->command->info('Service areas created successfully.');
    }
}

