<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        // Create roles
        $roles = [
            ['name' => 'SUPER_ADMIN', 'display_name' => 'Super Administrator', 'description' => 'Platform owner with full access'],
            ['name' => 'ORG_ADMIN', 'display_name' => 'Organization Admin', 'description' => 'Administrator of an organization'],
            ['name' => 'DISPATCHER', 'display_name' => 'Dispatcher', 'description' => 'Can triage and assign incidents'],
            ['name' => 'LEAD_AGENT', 'display_name' => 'Lead Agent', 'description' => 'Senior field agent'],
            ['name' => 'FIELD_AGENT', 'display_name' => 'Field Agent', 'description' => 'Field agent who resolves incidents'],
            ['name' => 'CITIZEN', 'display_name' => 'Citizen', 'description' => 'Citizen reporter'],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }

        // Create permissions
        $permissions = [
            ['name' => 'manage.organizations', 'display_name' => 'Manage Organizations'],
            ['name' => 'manage.users', 'display_name' => 'Manage Users'],
            ['name' => 'view.incidents', 'display_name' => 'View Incidents'],
            ['name' => 'create.incidents', 'display_name' => 'Create Incidents'],
            ['name' => 'update.incidents', 'display_name' => 'Update Incidents'],
            ['name' => 'assign.incidents', 'display_name' => 'Assign Incidents'],
            ['name' => 'delete.incidents', 'display_name' => 'Delete Incidents'],
            ['name' => 'manage.teams', 'display_name' => 'Manage Teams'],
            ['name' => 'manage.service_areas', 'display_name' => 'Manage Service Areas'],
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }

        // Assign permissions to roles
        $superAdmin = Role::where('name', 'SUPER_ADMIN')->first();
        $superAdmin->permissions()->attach(Permission::all());

        $orgAdmin = Role::where('name', 'ORG_ADMIN')->first();
        $orgAdmin->permissions()->attach(Permission::whereIn('name', [
            'manage.users',
            'view.incidents',
            'create.incidents',
            'update.incidents',
            'assign.incidents',
            'delete.incidents',
            'manage.teams',
            'manage.service_areas',
        ])->pluck('id'));

        $dispatcher = Role::where('name', 'DISPATCHER')->first();
        $dispatcher->permissions()->attach(Permission::whereIn('name', [
            'view.incidents',
            'update.incidents',
            'assign.incidents',
        ])->pluck('id'));

        $leadAgent = Role::where('name', 'LEAD_AGENT')->first();
        $leadAgent->permissions()->attach(Permission::whereIn('name', [
            'view.incidents',
            'update.incidents',
        ])->pluck('id'));

        $fieldAgent = Role::where('name', 'FIELD_AGENT')->first();
        $fieldAgent->permissions()->attach(Permission::whereIn('name', [
            'view.incidents',
            'update.incidents',
        ])->pluck('id'));

        $citizen = Role::where('name', 'CITIZEN')->first();
        $citizen->permissions()->attach(Permission::whereIn('name', [
            'create.incidents',
            'view.incidents',
        ])->pluck('id'));
    }
}

