<?php

namespace Database\Seeders;

use App\Models\Organization;
use Illuminate\Database\Seeder;

class OrganizationSeeder extends Seeder
{
    public function run(): void
    {
        $organizations = [
            [
                'name' => 'CIE Electricity Abidjan',
                'slug' => 'cie-electricity-abidjan',
                'email' => 'contact@cie.ci',
                'phone' => '+225 20 21 22 23',
                'address' => 'Abidjan, Côte d\'Ivoire',
                'is_active' => true,
            ],
            [
                'name' => 'SODECI Water Abidjan',
                'slug' => 'sodeci-water-abidjan',
                'email' => 'contact@sodeci.ci',
                'phone' => '+225 20 30 40 50',
                'address' => 'Abidjan, Côte d\'Ivoire',
                'is_active' => true,
            ],
        ];

        foreach ($organizations as $org) {
            Organization::firstOrCreate(['slug' => $org['slug']], $org);
        }
    }
}

