<?php

namespace Database\Seeders;

use App\Models\Incident;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DeleteIncidentsSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->info('Deleting all incidents...');
        
        // Delete related records first
        DB::table('incident_media')->delete();
        DB::table('incident_status_events')->delete();
        DB::table('assignments')->delete();
        DB::table('comments')->where('commentable_type', 'App\\Models\\Incident')->delete();
        DB::table('audit_logs')->where('entity_type', 'App\\Models\\Incident')->delete();
        
        // Delete incidents
        $deleted = DB::table('incidents')->delete();
        
        $this->command->info("Deleted {$deleted} incidents and all related records.");
    }
}

