<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DeleteAllIncidentDataSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->info('Deleting all incident-related data...');
        
        // Delete in correct order to respect foreign key constraints
        
        // 1. Delete comment media (depends on comments)
        $deleted = DB::table('comment_media')->delete();
        $this->command->info("Deleted {$deleted} comment media entries.");
        
        // 2. Delete comments (depends on incidents/assignments)
        $deleted = DB::table('comments')->delete();
        $this->command->info("Deleted {$deleted} comments.");
        
        // 3. Delete incident media (depends on incidents)
        $deleted = DB::table('incident_media')->delete();
        $this->command->info("Deleted {$deleted} incident media entries.");
        
        // 4. Delete incident status events (depends on incidents)
        $deleted = DB::table('incident_status_events')->delete();
        $this->command->info("Deleted {$deleted} incident status events.");
        
        // 5. Delete assignments (depends on incidents)
        $deleted = DB::table('assignments')->delete();
        $this->command->info("Deleted {$deleted} assignments.");
        
        // 6. Delete audit logs related to incidents (notifications)
        $deleted = DB::table('audit_logs')
            ->where('entity_type', 'App\Models\Incident')
            ->delete();
        $this->command->info("Deleted {$deleted} incident-related audit logs (notifications).");
        
        // 7. Delete audit logs related to comments (if any)
        $deleted = DB::table('audit_logs')
            ->where('entity_type', 'App\Models\Comment')
            ->delete();
        $this->command->info("Deleted {$deleted} comment-related audit logs.");
        
        // 8. Delete incidents (main table)
        $deleted = DB::table('incidents')->delete();
        $this->command->info("Deleted {$deleted} incidents.");
        
        $this->command->info('✅ All incident-related data deleted successfully.');
    }
}

