<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incidents', function (Blueprint $table) {
            $table->foreignId('triaged_by_id')->nullable()->after('assigned_to_id')->constrained('users')->nullOnDelete();
            $table->timestamp('triaged_at')->nullable()->after('triaged_by_id');
            $table->foreignId('assigned_by_id')->nullable()->after('triaged_at')->constrained('users')->nullOnDelete();
            $table->timestamp('assigned_at')->nullable()->after('assigned_by_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incidents', function (Blueprint $table) {
            $table->dropForeign(['triaged_by_id']);
            $table->dropForeign(['assigned_by_id']);
            $table->dropColumn(['triaged_by_id', 'triaged_at', 'assigned_by_id', 'assigned_at']);
        });
    }
};
