<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incident_media', function (Blueprint $table) {
            $table->enum('visibility', ['PUBLIC_TO_CITIZEN', 'INTERNAL_ONLY'])->default('PUBLIC_TO_CITIZEN')->after('order');
            $table->text('caption')->nullable()->after('visibility');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incident_media', function (Blueprint $table) {
            $table->dropColumn(['visibility', 'caption']);
        });
    }
};
