<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incident_status_events', function (Blueprint $table) {
            $table->string('event_type')->default('STATUS_CHANGE')->after('to_status');
            $table->enum('visibility', ['PUBLIC_TO_CITIZEN', 'INTERNAL_ONLY'])->default('PUBLIC_TO_CITIZEN')->after('event_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incident_status_events', function (Blueprint $table) {
            $table->dropColumn(['event_type', 'visibility']);
        });
    }
};
