<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('incidents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained()->cascadeOnDelete();
            $table->foreignId('reporter_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('reporter_contact')->nullable(); // For anonymous reports
            $table->string('service_type'); // electricity, water, roads, etc.
            $table->foreignId('incident_type_id')->nullable()->constrained()->nullOnDelete();
            $table->string('title');
            $table->text('description');
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->string('address_text')->nullable();
            $table->enum('status', [
                'REPORTED',
                'TRIAGED',
                'ASSIGNED',
                'IN_PROGRESS',
                'RESOLVED',
                'CLOSED',
                'REJECTED'
            ])->default('REPORTED');
            $table->enum('priority', [
                'LOW',
                'MEDIUM',
                'HIGH',
                'CRITICAL'
            ])->default('MEDIUM');
            $table->enum('verification_state', [
                'UNVERIFIED',
                'VERIFIED',
                'DUPLICATE'
            ])->default('UNVERIFIED');
            $table->string('assigned_to_type')->nullable(); // 'user' or 'team'
            $table->unsignedBigInteger('assigned_to_id')->nullable();
            $table->timestamp('resolved_at')->nullable();
            $table->timestamp('closed_at')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['organization_id', 'status']);
            $table->index(['organization_id', 'service_type']);
            $table->index(['assigned_to_type', 'assigned_to_id']);
            $table->index(['reporter_user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('incidents');
    }
};

