<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('incident_types', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->nullable()->constrained()->nullOnDelete();
            $table->string('name');
            $table->string('service_type'); // electricity, water, roads, etc.
            $table->text('description')->nullable();
            $table->string('icon')->nullable();
            $table->integer('estimated_resolution_hours')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['organization_id', 'service_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('incident_types');
    }
};

