<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('service_areas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('service_type'); // electricity, water, roads, etc.
            $table->text('description')->nullable();
            // Bounding box for MVP (can be upgraded to polygon later)
            $table->decimal('min_latitude', 10, 8)->nullable();
            $table->decimal('max_latitude', 10, 8)->nullable();
            $table->decimal('min_longitude', 11, 8)->nullable();
            $table->decimal('max_longitude', 11, 8)->nullable();
            // For future polygon support
            $table->json('polygon_coordinates')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['organization_id', 'service_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('service_areas');
    }
};

