<?php

namespace Database\Factories;

use App\Models\Organization;
use Illuminate\Database\Eloquent\Factories\Factory;

class ServiceAreaFactory extends Factory
{
    protected $model = \App\Models\ServiceArea::class;

    public function definition(): array
    {
        $minLat = fake()->latitude();
        $maxLat = $minLat + 0.1;
        $minLng = fake()->longitude();
        $maxLng = $minLng + 0.1;

        return [
            'organization_id' => Organization::factory(),
            'name' => fake()->city() . ' Service Area',
            'service_type' => fake()->randomElement(['electricity', 'water', 'roads']),
            'description' => fake()->sentence(),
            'min_latitude' => $minLat,
            'max_latitude' => $maxLat,
            'min_longitude' => $minLng,
            'max_longitude' => $maxLng,
            'is_active' => true,
        ];
    }
}

