<?php

namespace Database\Factories;

use App\Models\IncidentType;
use App\Models\Organization;
use Illuminate\Database\Eloquent\Factories\Factory;

class IncidentTypeFactory extends Factory
{
    protected $model = IncidentType::class;

    public function definition(): array
    {
        return [
            'organization_id' => Organization::factory(),
            'name' => fake()->words(2, true),
            'service_type' => fake()->randomElement(['electricity', 'water', 'roads']),
            'description' => fake()->sentence(),
            'estimated_resolution_hours' => fake()->numberBetween(2, 48),
            'is_active' => true,
        ];
    }
}

