<?php

namespace Database\Factories;

use App\Models\Incident;
use App\Models\IncidentType;
use App\Models\Organization;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class IncidentFactory extends Factory
{
    protected $model = Incident::class;

    public function definition(): array
    {
        return [
            'organization_id' => Organization::factory(),
            'reporter_user_id' => User::factory(),
            'reporter_contact' => fake()->phoneNumber(),
            'service_type' => fake()->randomElement(['electricity', 'water', 'roads']),
            'incident_type_id' => IncidentType::factory(),
            'title' => fake()->sentence(),
            'description' => fake()->paragraph(),
            'latitude' => fake()->latitude(),
            'longitude' => fake()->longitude(),
            'address_text' => fake()->address(),
            'status' => 'REPORTED',
            'priority' => fake()->randomElement(['LOW', 'MEDIUM', 'HIGH', 'CRITICAL']),
            'verification_state' => 'UNVERIFIED',
        ];
    }
}

