#!/bin/bash
# Script to create cache table in MySQL
# Usage: ./create_cache_table_manual.sh

# Read database credentials from .env file
if [ -f .env ]; then
    DB_DATABASE=$(grep "^DB_DATABASE=" .env | cut -d '=' -f2)
    DB_USERNAME=$(grep "^DB_USERNAME=" .env | cut -d '=' -f2)
    DB_PASSWORD=$(grep "^DB_PASSWORD=" .env | cut -d '=' -f2)
    DB_HOST=$(grep "^DB_HOST=" .env | cut -d '=' -f2 | sed 's/127.0.0.1/localhost/')
    
    echo "Creating cache tables in database: $DB_DATABASE"
    
    mysql -h "$DB_HOST" -u "$DB_USERNAME" -p"$DB_PASSWORD" "$DB_DATABASE" <<EOF
CREATE TABLE IF NOT EXISTS \`cache\` (
  \`key\` VARCHAR(255) NOT NULL PRIMARY KEY,
  \`value\` MEDIUMTEXT NOT NULL,
  \`expiration\` INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS \`cache_locks\` (
  \`key\` VARCHAR(255) NOT NULL PRIMARY KEY,
  \`owner\` VARCHAR(255) NOT NULL,
  \`expiration\` INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SHOW TABLES LIKE 'cache';
EOF
    
    echo "Cache tables created successfully!"
else
    echo "Error: .env file not found"
    exit 1
fi

