#!/bin/bash
# Script to change cache driver from database to file
# This fixes the cache table error

cd "$(dirname "$0")"

if [ ! -f .env ]; then
    echo "Error: .env file not found"
    exit 1
fi

# Check if CACHE_STORE or CACHE_DRIVER exists
if grep -q "^CACHE_STORE=" .env; then
    # Update existing CACHE_STORE
    sed -i.bak 's/^CACHE_STORE=.*/CACHE_STORE=file/' .env
    echo "Updated CACHE_STORE=file in .env"
elif grep -q "^CACHE_DRIVER=" .env; then
    # Update existing CACHE_DRIVER
    sed -i.bak 's/^CACHE_DRIVER=.*/CACHE_DRIVER=file/' .env
    echo "Updated CACHE_DRIVER=file in .env"
else
    # Add new CACHE_STORE line
    echo "" >> .env
    echo "# Cache Configuration" >> .env
    echo "CACHE_STORE=file" >> .env
    echo "Added CACHE_STORE=file to .env"
fi

echo ""
echo "✅ Cache driver changed to 'file'"
echo ""
echo "Now run:"
echo "  php artisan config:clear"
echo "  php artisan cache:clear"
echo ""

