<?php

namespace App\Services;

use App\Models\User;
use App\Models\Incident;
use Illuminate\Support\Facades\Queue;

interface NotificationServiceInterface
{
    public function sendToUser(User $user, string $title, string $body, array $data = []): bool;
    public function notifyNewIncident(Incident $incident): void;
    public function notifyIncidentAssigned(Incident $incident, $assignable): void;
    public function notifyStatusChange(Incident $incident, string $oldStatus, string $newStatus): void;
}

