<?php

namespace App\Services;

use App\Models\ServiceArea;
use App\Models\Organization;

class IncidentRoutingService
{
    public function routeToOrganization(string $serviceType, float $latitude, float $longitude): ?Organization
    {
        // Find service area that contains the location
        $serviceArea = ServiceArea::where('service_type', $serviceType)
            ->where('is_active', true)
            ->get()
            ->first(function ($area) use ($latitude, $longitude) {
                return $area->containsLocation($latitude, $longitude);
            });

        if ($serviceArea) {
            return $serviceArea->organization;
        }

        // Try to find a default organization for this service type
        $defaultOrg = Organization::whereHas('serviceAreas', function ($query) use ($serviceType) {
            $query->where('service_type', $serviceType)
                ->where('is_active', true);
        })
        ->where('is_active', true)
        ->first();

        return $defaultOrg;
    }
}

