<?php

namespace App\Services;

use App\Models\AuditLog;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class AuditService
{
    public function log(string $action, Model $entity, ?array $before = null, ?array $after = null): void
    {
        $user = Auth::user();
        $request = request();

        AuditLog::create([
            'organization_id' => $entity->organization_id ?? $user?->organization_id,
            'user_id' => $user?->id,
            'action' => $action,
            'entity_type' => get_class($entity),
            'entity_id' => $entity->id,
            'before' => $before,
            'after' => $after,
            'ip_address' => $request->ip(),
            'user_agent' => $request->userAgent(),
        ]);
    }
}

