<?php

namespace App\Policies;

use App\Models\User;

class UserPolicy
{
    public function viewAny(User $user): bool
    {
        return !$user->isCitizen();
    }

    public function view(User $user, User $model): bool
    {
        if ($user->isSuperAdmin()) {
            return true;
        }

        if ($user->isCitizen()) {
            return $user->id === $model->id;
        }

        return $user->organization_id === $model->organization_id;
    }

    public function create(User $user): bool
    {
        return $user->isOrgAdmin() || $user->isSuperAdmin();
    }

    public function update(User $user, User $model): bool
    {
        if ($user->isSuperAdmin()) {
            return true;
        }

        if ($user->isCitizen()) {
            return $user->id === $model->id;
        }

        return ($user->isOrgAdmin() || $user->isDispatcher()) 
            && $user->organization_id === $model->organization_id;
    }

    public function delete(User $user, User $model): bool
    {
        if ($user->isSuperAdmin()) {
            return true;
        }

        return $user->isOrgAdmin() && $user->organization_id === $model->organization_id;
    }
}

