<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceArea extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'organization_id',
        'name',
        'service_type',
        'description',
        'min_latitude',
        'max_latitude',
        'min_longitude',
        'max_longitude',
        'polygon_coordinates',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'polygon_coordinates' => 'array',
    ];

    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }

    public function containsLocation(float $latitude, float $longitude): bool
    {
        // Simple bounding box check for MVP
        if ($this->min_latitude && $this->max_latitude && $this->min_longitude && $this->max_longitude) {
            return $latitude >= $this->min_latitude
                && $latitude <= $this->max_latitude
                && $longitude >= $this->min_longitude
                && $longitude <= $this->max_longitude;
        }

        // Future: polygon check if polygon_coordinates is set
        return false;
    }
}

