<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Organization extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'slug',
        'email',
        'phone',
        'address',
        'logo_path',
        'is_active',
        'settings',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'settings' => 'array',
    ];

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function serviceAreas()
    {
        return $this->hasMany(ServiceArea::class);
    }

    public function incidents()
    {
        return $this->hasMany(Incident::class);
    }

    public function teams()
    {
        return $this->hasMany(Team::class);
    }

    public function incidentTypes()
    {
        return $this->hasMany(IncidentType::class);
    }
}

