<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentStatusEvent extends Model
{
    use HasFactory;

    protected $fillable = [
        'incident_id',
        'user_id',
        'from_status',
        'to_status',
        'notes',
        'metadata',
        'event_type',
        'visibility',
    ];

    protected $casts = [
        'metadata' => 'array',
    ];

    public function incident()
    {
        return $this->belongsTo(Incident::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}

