<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentMedia extends Model
{
    use HasFactory;

    protected $fillable = [
        'incident_id',
        'file_path',
        'file_name',
        'mime_type',
        'file_size',
        'media_type',
        'order',
        'visibility',
        'caption',
    ];

    protected $casts = [
        'file_size' => 'integer',
        'order' => 'integer',
    ];

    public function incident()
    {
        return $this->belongsTo(Incident::class);
    }
}

