<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class IncidentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'organization_id' => $this->organization_id,
            'organization' => $this->when($this->organization, fn() => [
                'id' => $this->organization->id,
                'name' => $this->organization->name,
            ]),
            'reporter' => $this->when($this->reporter, fn() => [
                'id' => $this->reporter->id,
                'name' => $this->reporter->name,
                'email' => $this->reporter->email,
            ]),
            'reporter_contact' => $this->reporter_contact,
            'service_type' => $this->service_type,
            'incident_type' => $this->when($this->incidentType, fn() => [
                'id' => $this->incidentType->id,
                'name' => $this->incidentType->name,
            ]),
            'title' => $this->title,
            'description' => $this->description ?? '',
            'location' => [
                // Return null only for NULL database values (mobile app compatible)
                // Return actual value (including 0) if it exists (0 is valid coordinate near Gulf of Guinea)
                // Frontend handles null by converting to 0, so both apps are compatible
                'latitude' => $this->latitude !== null ? (float) $this->latitude : null,
                'longitude' => $this->longitude !== null ? (float) $this->longitude : null,
                'address' => $this->address_text ?? '',
            ],
            'status' => $this->status,
            'priority' => $this->priority,
            'verification_state' => $this->verification_state,
            'assigned_to' => $this->when($this->assigned_to_id, function () {
                $assigned = $this->assigned_to;
                if (!$assigned) {
                    return null;
                }
                return [
                    'type' => $this->assigned_to_type,
                    'id' => $assigned->id,
                    'name' => $assigned->name,
                ];
            }),
            'resolved_at' => $this->resolved_at?->toISOString(),
            'closed_at' => $this->closed_at?->toISOString(),
            'resolution_notes' => $this->resolution_notes,
            'media' => IncidentMediaResource::collection($this->whenLoaded('media')),
            'created_at' => $this->created_at ? $this->created_at->toISOString() : now()->toISOString(),
            'updated_at' => $this->updated_at ? $this->updated_at->toISOString() : now()->toISOString(),
        ];
    }
}

