<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class IncidentMediaResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        // If file_path is already a full URL (external), use it directly
        // Otherwise, treat it as a local storage path and generate absolute URL
        if (str_starts_with($this->file_path, 'http://') || str_starts_with($this->file_path, 'https://')) {
            $url = $this->file_path;
        } else {
            // Generate absolute URL using APP_URL
            $baseUrl = rtrim(config('app.url'), '/');
            $storagePath = 'storage/' . ltrim($this->file_path, '/');
            $url = $baseUrl . '/' . $storagePath;
        }

        return [
            'id' => $this->id,
            'file_name' => $this->file_name,
            'file_path' => $this->file_path,
            'url' => $url,
            'mime_type' => $this->mime_type,
            'file_size' => $this->file_size,
            'media_type' => $this->media_type,
        ];
    }
}

