<?php

namespace App\Http\Requests\Incidents;

use Illuminate\Foundation\Http\FormRequest;

class UpdateIncidentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('update', $this->route('incident'));
    }

    public function rules(): array
    {
        return [
            'title' => ['sometimes', 'string', 'max:255'],
            'description' => ['sometimes', 'string', 'max:5000'],
            'priority' => ['sometimes', 'string', 'in:LOW,MEDIUM,HIGH,CRITICAL'],
            'verification_state' => ['sometimes', 'string', 'in:UNVERIFIED,VERIFIED,DUPLICATE'],
            'incident_type_id' => ['sometimes', 'nullable', 'exists:incident_types,id'],
            'resolution_notes' => ['sometimes', 'nullable', 'string', 'max:5000'],
        ];
    }
}

