<?php

namespace App\Http\Requests\Incidents;

use Illuminate\Foundation\Http\FormRequest;

class CreateIncidentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // Anyone can create incidents
    }

    public function rules(): array
    {
        return [
            'service_type' => ['required', 'string', 'in:electricity,water,roads,waste,other'],
            'incident_type_id' => ['nullable', 'exists:incident_types,id'],
            'title' => ['required', 'string', 'max:255'],
            'description' => ['required', 'string', 'max:5000'],
            'latitude' => ['required', 'numeric', 'between:-90,90'],
            'longitude' => ['required', 'numeric', 'between:-180,180'],
            'address_text' => ['nullable', 'string', 'max:500'],
            'reporter_contact' => ['nullable', 'string', 'max:100'],
            'media' => ['nullable', 'array', 'max:10'],
            'media.*' => ['file', 'mimes:jpeg,jpg,png,gif,webp,mp4,mov,pdf,m4a,aac,mpeg,mp3', 'max:10240'],
        ];
    }
}

