<?php

namespace App\Http\Requests\Incidents;

use Illuminate\Foundation\Http\FormRequest;

class ChangeStatusRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('update', $this->route('incident'));
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'string', 'in:REPORTED,TRIAGED,ASSIGNED,IN_PROGRESS,RESOLVED,CLOSED,REJECTED'],
            'notes' => ['nullable', 'string', 'max:1000'],
        ];
    }

    public function withValidator($validator): void
    {
        $validator->after(function ($validator) {
            $incident = $this->route('incident');
            $newStatus = $this->input('status');

            if (!$incident->canTransitionTo($newStatus)) {
                $validator->errors()->add(
                    'status',
                    "Cannot transition from {$incident->status} to {$newStatus}."
                );
            }
        });
    }
}

