<?php

namespace App\Http\Requests\Incidents;

use Illuminate\Foundation\Http\FormRequest;

class AssignIncidentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->can('assign', $this->route('incident'));
    }

    public function rules(): array
    {
        return [
            'assignable_type' => ['required', 'string', 'in:user,team'],
            'assignable_id' => ['required', 'integer'],
            'notes' => ['nullable', 'string', 'max:1000'],
        ];
    }

    public function withValidator($validator): void
    {
        $validator->after(function ($validator) {
            $assignableType = $this->input('assignable_type');
            $assignableId = $this->input('assignable_id');

            if ($assignableType === 'user') {
                $exists = \App\Models\User::where('id', $assignableId)
                    ->where('organization_id', $this->route('incident')->organization_id)
                    ->exists();
                if (!$exists) {
                    $validator->errors()->add('assignable_id', 'User does not exist in this organization.');
                }
            } elseif ($assignableType === 'team') {
                $exists = \App\Models\Team::where('id', $assignableId)
                    ->where('organization_id', $this->route('incident')->organization_id)
                    ->exists();
                if (!$exists) {
                    $validator->errors()->add('assignable_id', 'Team does not exist in this organization.');
                }
            }
        });
    }
}

