<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureTenantIsolation
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if ($user && !$user->isSuperAdmin() && $user->organization_id) {
            // Set organization context for non-super-admin users
            $request->attributes->set('organization_id', $user->organization_id);
        }

        return $next($request);
    }
}

