# Refresh All Incident Data

This document explains how to delete and recreate all incident-related data to ensure accuracy and consistency.

## Overview

The `RefreshAllIncidentDataSeeder` is a master seeder that:
1. Deletes all incident-related data (comments, notifications, assignments, status events, media, incidents)
2. Recreates everything in the correct order to ensure data integrity

## What Gets Deleted

The seeder deletes data from the following tables (in order):
1. `comment_media` - Media files attached to comments
2. `comments` - All comments on incidents and assignments
3. `incident_media` - Media files attached to incidents
4. `incident_status_events` - Status change history
5. `assignments` - Assignment records
6. `audit_logs` (incident-related) - Notifications for incidents
7. `audit_logs` (comment-related) - Notifications for comments
8. `incidents` - All incident records

## What Gets Recreated

The seeder recreates data in the following order:

### 1. Incidents (`IncidentSeeder`)
- Creates 200 electricity incidents (CIE)
- Creates 200 water incidents (SODECI)
- Each incident includes:
  - Complete incident data (title, description, location, status, priority)
  - Status timeline events
  - Assignment records (for ASSIGNED/IN_PROGRESS/RESOLVED incidents)
  - Media files (images and audio)
  - `assigned_at` timestamp (for assigned incidents)

### 2. Comments (`RecreateCommentsSeeder`)
- Creates comments for incidents (60% chance per incident)
- Creates comments for assignments (40% chance per assignment)
- Each comment may include:
  - Comment body (French text)
  - Media files (50% chance, 1-3 images)
  - Notification (audit log entry) for `comment_added`

### 3. Notifications (`RecreateNotificationsSeeder`)
- Creates `created` notifications from incidents
- Creates `assigned` notifications from assignments table
- Creates `status_changed` notifications from status events
- Note: `comment_added` notifications are already created by `RecreateCommentsSeeder`

## Usage

To refresh all incident data:

```bash
cd backend
php artisan db:seed --class=RefreshAllIncidentDataSeeder
```

## Data Accuracy

This seeder ensures data accuracy by:
- **Consistent relationships**: All foreign keys are properly maintained
- **Complete data**: All required fields are populated with sensible defaults
- **Realistic timelines**: Status events and assignments have realistic timestamps
- **Proper notifications**: All notifications are linked to the correct incidents and users
- **No orphaned records**: Everything is deleted before recreation

## Dependencies

The seeder requires the following to be seeded first:
- `RoleSeeder` - User roles
- `SuperAdminSeeder` - Super admin user
- `OrganizationSeeder` - Organizations (CIE and SODECI)
- `ServiceAreaSeeder` - Service areas
- `IncidentTypeSeeder` - Incident types
- `UserSeeder` - Users (citizens, agents, dispatchers)
- `TeamSeeder` - Teams

Run the full database seeder first:

```bash
php artisan db:seed
```

Then run the refresh seeder:

```bash
php artisan db:seed --class=RefreshAllIncidentDataSeeder
```

## Individual Seeders

You can also run individual seeders if needed:

```bash
# Delete all incident data
php artisan db:seed --class=DeleteAllIncidentDataSeeder

# Recreate incidents only
php artisan db:seed --class=IncidentSeeder

# Recreate comments only
php artisan db:seed --class=RecreateCommentsSeeder

# Recreate notifications only
php artisan db:seed --class=RecreateNotificationsSeeder
```

## Notes

- The seeder uses French text for incident titles, descriptions, and comments
- Media files use placeholder images from `picsum.photos`
- All dates are randomized within the last 60 days
- Assignments are created automatically when incidents transition to ASSIGNED status
- Comment notifications are created by `RecreateCommentsSeeder`, not `RecreateNotificationsSeeder`

