# Recreate Comments Seeder

## Overview

The `RecreateCommentsSeeder` deletes all existing comments and comment media from the database and recreates them based on the current incidents in the database. It also creates comment notifications (audit log entries) for each comment.

## What It Does

1. **Deletes existing comments**:
   - Deletes all entries from `comment_media` table
   - Deletes all entries from `comments` table

2. **Recreates comments from current incidents**:
   - Only processes incidents with status: `ASSIGNED`, `IN_PROGRESS`, or `RESOLVED`
   - 60% chance of having comments per incident
   - 1-5 comments per incident
   - 50% chance of comments having images (1-3 images per comment)
   - Uses French comment messages
   - Uses placeholder images from picsum.photos

3. **Creates comment notifications**:
   - Creates audit log entries with action `comment_added`
   - Links notifications to the incident
   - Visible to organization members and assigned users

## Usage

### Run the seeder directly:

```bash
cd backend
php artisan db:seed --class=RecreateCommentsSeeder
```

### Or add it to DatabaseSeeder:

```php
// database/seeders/DatabaseSeeder.php
public function run(): void
{
    // ... other seeders ...
    
    $this->call(RecreateCommentsSeeder::class);
}
```

## Output

The seeder will display progress information:

```
Deleting existing comments...
Deleted 123 comments and all related media.
Recreating comments from current incidents...
Processing 400 incidents for comments...
✅ Created 245 comments.
✅ Created 245 comment notifications in audit_logs.
```

## Comment Content

The seeder uses 20 realistic French comment messages including:
- "Inspection sur site terminée. Problème confirmé."
- "En attente de l'arrivée des pièces. Livraison estimée: 2 jours."
- "Travaux en cours. Mise à jour une fois terminé."
- And more...

## Media Files

- Uses picsum.photos for working placeholder images
- Each comment gets unique random images based on comment ID
- File sizes: 500KB - 2MB (random)
- MIME type: `image/jpeg`
- Media type: `image`

## Notifications

Each comment creates an audit log entry with:
- **action**: `comment_added`
- **entity_type**: `App\Models\Incident`
- **entity_id**: Incident ID
- **user_id**: User who created the comment
- **after**: JSON with comment_id and comment_body (first 100 chars)

The `NotificationController` has been updated to handle `comment_added` actions and will display: "New comment: {comment body}"

## Prerequisites

- ✅ Users with roles: `FIELD_AGENT`, `LEAD_AGENT`, or `DISPATCHER`
- ✅ Incidents with status: `ASSIGNED`, `IN_PROGRESS`, or `RESOLVED`

These should be created by other seeders:
- `UserSeeder` - Creates users
- `IncidentSeeder` - Creates incidents

## Related Changes

### IncidentSeeder Updates
- ✅ Ensured `description` always has a value (fallback: "Aucune description fournie.")
- ✅ Ensured `latitude` and `longitude` always have values
- ✅ Ensured `address_text` always has a value (fallback: "Adresse non spécifiée")
- ✅ Ensured `status` always has a value (fallback: "REPORTED")
- ✅ Ensured `priority` always has a value (fallback: "MEDIUM")

### NotificationController Updates
- ✅ Added `comment_added` to the list of notification actions
- ✅ Added message formatting for `comment_added` notifications

## Example Workflow

1. Delete all incidents (optional):
   ```bash
   php artisan db:seed --class=DeleteIncidentsSeeder
   ```

2. Recreate incidents with proper data:
   ```bash
   php artisan db:seed --class=IncidentSeeder
   ```

3. Recreate comments and notifications:
   ```bash
   php artisan db:seed --class=RecreateCommentsSeeder
   ```

4. Recreate other notifications (optional):
   ```bash
   php artisan db:seed --class=RecreateNotificationsSeeder
   ```

