# Recent Activities Information

## Overview

Recent activities in the `nesos_agent` app are **already seeded** through the `NotificationSeeder`. They use the same `audit_logs` data source as notifications.

## How Recent Activities Work

The dashboard's "Recent Activity" section fetches data from the `/api/v1/notifications` endpoint, which reads from the `audit_logs` table.

### Data Flow

1. **Backend**: `NotificationController` queries `audit_logs` table
2. **Frontend**: `DashboardRepository.getRecentActivity()` calls `/api/v1/notifications`
3. **Display**: Activities are shown in the dashboard with icons and timestamps

### Activity Types

Activities are derived from audit log actions:
- **created** - "New incident reported"
- **assigned** - "Incident assigned"
- **status_changed** - "Incident status updated"

## Seeding

Recent activities are automatically seeded when you run:

```bash
php artisan db:seed --class=NotificationSeeder
```

Or when running all seeders:

```bash
php artisan db:seed
```

The `NotificationSeeder` creates audit log entries that serve as both:
- **Notifications** (when viewed in the notifications page)
- **Recent Activities** (when viewed in the dashboard)

## No Separate Seeder Needed

Since recent activities use the same data source as notifications, **no separate seeder is required**. The `NotificationSeeder` already creates all the necessary audit log entries.

## Activity Display

Activities are displayed in the dashboard with:
- Icon based on activity type
- Title (e.g., "New incident reported")
- Description (from notification message)
- Relative timestamp (e.g., "2h ago", "3d ago")

---

**Last Updated**: December 28, 2025

