# Quick Fix: Change Cache Driver to File

## The Problem
Laravel is trying to use database cache (`cache` table), but the table doesn't exist. Even `php artisan cache:clear` fails because it tries to use the cache table.

## The Solution
Change the cache driver from `database` to `file` in your `.env` file.

### Step 1: Update .env file

**Option A: Use the script (easiest)**
```bash
cd backend
./change_cache_to_file.sh
```

**Option B: Manual edit**
Open `.env` and add/update this line:
```env
CACHE_STORE=file
```

If you see `CACHE_DRIVER=database`, change it to:
```env
CACHE_DRIVER=file
```

### Step 2: Clear config cache
```bash
php artisan config:clear
```

### Step 3: Test cache clear
```bash
php artisan cache:clear
```

This should now work! ✅

## What Changed
- **Before:** Cache stored in database (`cache` table)
- **After:** Cache stored in files (`storage/framework/cache/data/`)

## Why This Works
- File cache doesn't need a database table
- Works immediately without setup
- Same performance for most use cases
- Easy to clear (just delete cache files)

---

**After this change, incident creation will work without the cache table error!**

