# MySQL Database Setup

## Quick Setup Steps

### 1. Ensure MySQL is Running

Check if MySQL is running:
```bash
# macOS (Homebrew)
brew services list | grep mysql

# Start MySQL if not running
brew services start mysql
```

### 2. Create the Database

You have two options:

**Option A: Using MySQL command line (recommended)**
```bash
mysql -u root -p -e "CREATE DATABASE ne_sos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
```

**Option B: Using Laravel (if credentials are set)**
```bash
php artisan db:create
```

### 3. Update .env File

Edit `.env` and set your MySQL credentials:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=ne_sos
DB_USERNAME=root
DB_PASSWORD=your_mysql_password_here
```

### 4. Run Migrations and Seeders

```bash
php artisan migrate:fresh --seed
```

This will:
- Drop all existing tables
- Create all tables from migrations
- Seed the database with default data (admin user, roles, organizations, etc.)

### 5. Verify Setup

Test the connection:
```bash
php artisan db:show
```

### Default Login Credentials

After seeding:
- **Email**: `admin@ne-sos.com`
- **Password**: `password`

## Troubleshooting

### Connection Refused
If you get "Connection refused":
- Ensure MySQL is running: `brew services start mysql`
- Check MySQL is listening on port 3306: `lsof -i :3306`

### Access Denied
If you get "Access denied":
- Verify your MySQL root password in `.env`
- Try creating a dedicated MySQL user:
  ```sql
  CREATE USER 'ne_sos_user'@'localhost' IDENTIFIED BY 'your_password';
  GRANT ALL PRIVILEGES ON ne_sos.* TO 'ne_sos_user'@'localhost';
  FLUSH PRIVILEGES;
  ```
- Then update `.env` with the new credentials

### Database Already Exists
If the database already exists and you want to start fresh:
```bash
php artisan migrate:fresh --seed
```

This will drop all tables and recreate them.

