# Missing Comments Table Fix

## Problem

The app is getting a 500 error when trying to fetch comments:
```
SQLSTATE[42S02]: Base table or view not found: 1146 Table 'ne_sos.comments' doesn't exist
```

## Root Cause

The `comments` table migration exists but hasn't been run on the MySQL production database. The table exists in SQLite (test database) but not in MySQL.

## Solution

Run the pending migrations on the MySQL database:

```bash
cd backend
php artisan migrate --force
```

Or specifically run the comments table migrations:

```bash
php artisan migrate --path=database/migrations/2025_01_01_000001_create_comments_table.php --force
php artisan migrate --path=database/migrations/2025_01_01_000002_create_comment_media_table.php --force
```

## Verification

After running migrations, verify the table exists:

```bash
php artisan tinker
>>> Schema::hasTable('comments')
=> true
>>> Schema::hasTable('comment_media')
=> true
```

## Status

- ✅ Migration file exists: `2025_01_01_000001_create_comments_table.php`
- ✅ Migration file exists: `2025_01_01_000002_create_comment_media_table.php`
- ✅ **FIXED:** Migrations have been run on MySQL database (December 28, 2025)

---

**Last Updated:** December 28, 2025

