# French Incidents Update

## Summary
Updated the incident seeder to generate French content for all incidents.

## Changes Made

### 1. Incident Titles (French)
- Updated electricity incident titles to French
- Updated water incident titles to French
- Added more variety (10 titles per service type)

### 2. Faker Locale
- Changed all `fake()` calls to `fake('fr_FR')` for:
  - Street names
  - Descriptions
  - Addresses
  - Timeline notes

### 3. Error Handling
- Fixed `random()` calls to check for empty collections first
- Prevents errors when no users/agents/incident types exist

## French Incident Titles

### Electricity
- Panne de courant dans le quartier
- Ligne électrique cassée dans la rue
- Dysfonctionnement du transformateur
- Éclairage public non fonctionnel
- Problème de compteur électrique
- Surtension électrique signalée
- Ligne électrique tombée
- Panne d'électricité prolongée
- Court-circuit dans le secteur
- Poteau électrique endommagé

### Water
- Fuite d'eau sur l'artère principale
- Absence d'approvisionnement en eau dans la zone
- Préoccupations concernant la qualité de l'eau
- Canalisation d'eau cassée
- Problème de compteur d'eau
- Basse pression d'eau
- Rapport de contamination de l'eau
- Rupture de canalisation principale
- Eau trouble ou colorée
- Station de pompage en panne

## Usage

To regenerate incidents with French content:

```bash
cd backend
php artisan db:seed --class=DeleteIncidentsSeeder --force
php artisan db:seed --class=IncidentSeeder --force
```

## Notes

- All incidents will have French titles, descriptions, and addresses
- Timeline notes will also be in French
- Existing incidents should be deleted first using `DeleteIncidentsSeeder`

