# Fix Cache Permissions Issue

## Problem
Getting error: "Failed to clear cache. Make sure you have the appropriate permissions."

## Solution

### Step 1: Set Proper Permissions
```bash
cd backend
chmod -R 775 storage bootstrap/cache
```

### Step 2: Ensure Cache Directories Exist
```bash
mkdir -p storage/framework/cache/data
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/logs
```

### Step 3: Change Cache Driver to File
Edit `.env` and add/update:
```env
CACHE_STORE=file
```

Or use the script:
```bash
./change_cache_to_file.sh
```

### Step 4: Clear Cache Manually (if needed)
```bash
# Delete cache files directly
rm -rf storage/framework/cache/data/*
```

### Step 5: Try Again
```bash
php artisan config:clear
php artisan cache:clear
```

## If Still Having Issues

### Check Ownership
If you're using a web server (like Apache/Nginx), the storage directory might need to be owned by the web server user:

```bash
# For Apache
sudo chown -R www-data:www-data storage bootstrap/cache

# For Nginx
sudo chown -R www-data:www-data storage bootstrap/cache

# Or for your user
sudo chown -R $USER:$USER storage bootstrap/cache
```

### Verify Permissions
```bash
ls -la storage/framework/cache/
```

Should show directories are writable (drwxrwxr-x).

---

**After fixing permissions and setting CACHE_STORE=file, cache operations should work!**

