# Quick Fix: Change Cache Driver to File

## The Problem
Laravel is trying to use database cache (`cache` table), but the table doesn't exist and MySQL may not allow creating it.

## The Solution
Change the cache driver from `database` to `file` in your `.env` file.

### Step 1: Edit `.env` file
Add or update this line:
```env
CACHE_STORE=file
```

### Step 2: Clear config cache
```bash
php artisan config:clear
```

### Step 3: Test
```bash
php artisan cache:clear
```

This should now work without errors!

## What This Does
- Switches from database cache to file-based cache
- Cache files will be stored in `storage/framework/cache/data/`
- No database table needed
- Same functionality, different storage

---

**That's it!** After this change, incident creation should work without the cache table error.

