# Comment Seeder Information

## Overview

The `CommentSeeder` creates dummy comments for incidents and assignments with realistic data for testing and development.

## Features

### Comment Generation

- **For Incidents**: 
  - Adds comments to incidents with status: `ASSIGNED`, `IN_PROGRESS`, or `RESOLVED`
  - 60% chance of having comments per incident
  - 1-5 comments per incident
  - 50% chance of comments having images (1-3 images per comment)

- **For Assignments**:
  - Adds comments to active assignments (not unassigned)
  - 40% chance of having comments per assignment
  - 1-3 comments per assignment
  - 40% chance of comments having images (1-2 images per comment)

### Comment Content

15 realistic comment messages including:
- "On-site inspection completed. Issue confirmed."
- "Waiting for parts to arrive. Estimated delivery: 2 days."
- "Work in progress. Will update once complete."
- "Additional photos attached for reference."
- "Team dispatched to location. ETA 30 minutes."
- "Issue resolved. Please verify."
- And more...

### Media Files

- Uses proper storage paths: `comments/{comment_id}/{filename}`
- 10 different realistic image file names:
  - `inspection-photo-1.jpg`
  - `work-progress-1.jpg`
  - `issue-detail-1.jpg`
  - `before-repair-1.jpg`
  - `after-repair-1.jpg`
  - `equipment-photo-1.jpg`
  - `location-marker-1.jpg`
  - `damage-assessment-1.jpg`
  - `completed-work-1.jpg`
  - `safety-check-1.jpg`
- File sizes: 500KB - 2MB (random)
- MIME type: `image/jpeg`
- Media type: `image`

### User Assignment

- Comments are created by users with roles: `FIELD_AGENT`, `LEAD_AGENT`, or `DISPATCHER`
- Random user selection for each comment

### Timestamps

- Comments have realistic timestamps:
  - Incidents: Created within last 30 days
  - Assignments: Created within last 20 days
  - Random hours within each day

## Usage

The seeder is automatically called when running:

```bash
php artisan db:seed
```

Or run it individually:

```bash
php artisan db:seed --class=CommentSeeder
```

## Prerequisites

The seeder requires:
- ✅ Users with roles: `FIELD_AGENT`, `LEAD_AGENT`, or `DISPATCHER`
- ✅ Incidents with status: `ASSIGNED`, `IN_PROGRESS`, or `RESOLVED`
- ✅ Active assignments (not unassigned)

These should be created by other seeders that run before `CommentSeeder`:
- `UserSeeder` - Creates users
- `IncidentSeeder` - Creates incidents
- `AssignIncidentsToAgentSeeder` - Creates assignments

## Database Structure

### Comments Table
- `id` - Primary key
- `commentable_type` - `App\Models\Incident` or `App\Models\Assignment`
- `commentable_id` - ID of incident or assignment
- `user_id` - User who created the comment
- `body` - Comment text
- `created_at` - Timestamp
- `updated_at` - Timestamp
- `deleted_at` - Soft delete (nullable)

### Comment Media Table
- `id` - Primary key
- `comment_id` - Foreign key to comments
- `file_path` - Storage path (e.g., `comments/123/inspection-photo-1.jpg`)
- `file_name` - Original file name
- `mime_type` - MIME type (e.g., `image/jpeg`)
- `file_size` - File size in bytes
- `media_type` - Type: `image`, `video`, or `document`
- `order` - Display order
- `created_at` - Timestamp
- `updated_at` - Timestamp

## Notes

- The seeder uses placeholder file paths. Actual image files are not created.
- To display images in the app, you would need to:
  1. Place actual image files in `storage/app/public/comments/{comment_id}/`
  2. Run `php artisan storage:link` to create the symbolic link
  3. Or use a placeholder image service

## Example Output

```
Adding comments to 45 incidents...
Adding comments to 23 assignments...
Comment seeding completed.
```

---

**Last Updated**: December 28, 2025

