# Cache Table Fix Instructions

## Issue
The `cache` table doesn't exist in your MySQL database, causing 500 errors when creating incidents.

## Quick Fix

### Option 1: Run SQL Script (Recommended)
Run the SQL script directly in MySQL:

```bash
mysql -u your_username -p ne_sos < create_cache_table.sql
```

Or connect to MySQL and run:
```sql
CREATE TABLE IF NOT EXISTS `cache` (
  `key` VARCHAR(255) NOT NULL PRIMARY KEY,
  `value` MEDIUMTEXT NOT NULL,
  `expiration` INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` VARCHAR(255) NOT NULL PRIMARY KEY,
  `owner` VARCHAR(255) NOT NULL,
  `expiration` INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

### Option 2: Use Laravel Migration
If the migration shows as "Ran" but table doesn't exist, reset and re-run:

```bash
# Remove from migrations table
php artisan tinker
>>> DB::table('migrations')->where('migration', '2025_12_28_130823_create_cache_table')->delete();

# Run migration again
php artisan migrate --path=database/migrations/2025_12_28_130823_create_cache_table.php --force
```

### Option 3: Use Laravel Artisan
```bash
php artisan cache:table
php artisan migrate
```

## After Creating Table

1. Clear Laravel caches:
```bash
php artisan cache:clear
php artisan config:clear
```

2. Restart Laravel server if running:
```bash
# Stop current server (Ctrl+C)
php artisan serve
```

## Verification

Check if table exists:
```bash
php artisan db:table cache
```

Or in MySQL:
```sql
SHOW TABLES LIKE 'cache';
DESCRIBE cache;
```

---

**Last Updated**: December 28, 2025

