# Cache Table Creation

## Issue
The `cache` table was missing from the database, causing 500 errors when creating incidents:
```
SQLSTATE[42S02]: Base table or view not found: 1146 Table 'ne_sos.cache' doesn't exist
```

## Solution

### Migration Status
The migration `2025_12_28_130823_create_cache_table.php` was created and run successfully.

### Tables Created
1. **`cache`** - Stores cache entries
   - `key` (string, primary)
   - `value` (mediumText)
   - `expiration` (integer)

2. **`cache_locks`** - Stores cache locks
   - `key` (string, primary)
   - `owner` (string)
   - `expiration` (integer)

### Verification
To verify the table exists:
```bash
php artisan db:table cache
```

### If Table Still Missing
If the table doesn't exist, run:
```bash
php artisan migrate:refresh --path=database/migrations/2025_12_28_130823_create_cache_table.php --force
```

Or manually create it:
```sql
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL PRIMARY KEY,
  `value` mediumtext NOT NULL,
  `expiration` int NOT NULL
);

CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL PRIMARY KEY,
  `owner` varchar(255) NOT NULL,
  `expiration` int NOT NULL
);
```

### After Creating Table
Clear Laravel caches:
```bash
php artisan cache:clear
php artisan config:clear
```

Then restart the Laravel server if it's running.

---

**Last Updated**: December 28, 2025

